/*
 * Decompiled with CFR 0.152.
 */
package org.exist.remoteconsole;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.exist.console.ConsoleAdapter;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.DateTimeValue;

public class RemoteConsoleAdapter
implements ConsoleAdapter {
    private final BiConsumer<String, Map> remoteDataWriter;
    private final BiConsumer<String, String> remoteStringWriter;

    public RemoteConsoleAdapter(BiConsumer<String, Map> remoteDataWriter, BiConsumer<String, String> remoteStringWriter) {
        this.remoteDataWriter = remoteDataWriter;
        this.remoteStringWriter = remoteStringWriter;
    }

    @Override
    public void log(String channel, String message) {
        this.log(channel, false, message);
    }

    @Override
    public void log(String channel, boolean json, String message) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("json", json);
        data.put("message", message);
        data.put("timestamp", this.getTimestamp());
        this.remoteDataWriter.accept(channel, data);
    }

    @Override
    public void log(String channel, String source, int line, int column, String message) {
        this.log(channel, source, line, column, false, message);
    }

    @Override
    public void log(String channel, String source, int line, int column, boolean json, String message) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("source", source);
        data.put("line", line);
        data.put("column", column);
        data.put("json", json);
        data.put("message", message);
        data.put("timestamp", this.getTimestamp());
        this.remoteDataWriter.accept(channel, data);
    }

    @Override
    public void send(String channel, String jsonString) {
        this.remoteStringWriter.accept(channel, jsonString);
    }

    private String getTimestamp() {
        try {
            return new DateTimeValue().getStringValue();
        }
        catch (XPathException e) {
            return null;
        }
    }
}

