/*
 * Decompiled with CFR 0.152.
 */
package org.exist.console.xquery;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.exist.dom.QName;
import org.exist.util.Configuration;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class JMXToken
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("jmx-token", "http://exist-db.org/xquery/console", "console"), "Retrieves the authentication token required for access to the JMX servlet.", null, (SequenceType)new FunctionReturnSequenceType(22, Cardinality.ZERO_OR_ONE, "The authentication token"));

    public JMXToken(XQueryContext context) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] sequences, Sequence sequence) throws XPathException {
        if (!this.context.getEffectiveUser().hasDbaRole()) {
            throw new XPathException((Expression)this, "Only a dba user is allowed to retrieve the JMX access token.");
        }
        Configuration configuration = this.context.getBroker().getConfiguration();
        Object dataDirProp = configuration.getProperty("db-connection.data-dir");
        if (dataDirProp == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Path dataDir = dataDirProp instanceof String ? Paths.get(dataDirProp.toString(), new String[0]) : (Path)dataDirProp;
        Path tokenFile = dataDir.resolve("jmxservlet.token");
        if (!Files.exists(tokenFile, new LinkOption[0])) return Sequence.EMPTY_SEQUENCE;
        try (InputStream is = Files.newInputStream(tokenFile, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(is);
            String key = properties.getProperty("token");
            if (key == null) return Sequence.EMPTY_SEQUENCE;
            StringValue stringValue = new StringValue(key);
            return stringValue;
        }
        catch (IOException ex) {
            throw new XPathException((Expression)this, "Exception while reading token file: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

